% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{nt_ch_stunt}
\alias{nt_ch_stunt}
\title{CN_NUTS_C_HA2
stunting
Children stunted
NT_CH_NUT.do PR "Stunted child under 5 years"
Stunting rate (Prevalence of stunted (HAZ < -2) children under five (0-59 months))
Percentage of children under age five stunted (below -2 standard deviations of height-for-age according to the WHO standard).}
\usage{
nt_ch_stunt(Rdata)
}
\arguments{
\item{Rdata}{data.frame from survryPrev::getDHSdata}
}
\value{
A partially processed data.frame that will be used in  survryPrev::getDHSindicator. The whole function can be used as a parameter in survryPrev::getDHSindicator
}
\description{
CN_NUTS_C_HA2
stunting
Children stunted
NT_CH_NUT.do PR "Stunted child under 5 years"
Stunting rate (Prevalence of stunted (HAZ < -2) children under five (0-59 months))
Percentage of children under age five stunted (below -2 standard deviations of height-for-age according to the WHO standard).
}
\examples{
\dontrun{
dhsData <- getDHSdata(country = "Zambia",
                                 indicator = "CN_NUTS_C_HA2",
                                 year = 2018)
data <- getDHSindicator(dhsData, indicator = NULL,
                         FUN = surveyPrev::nt_ch_stunt)
}
}
\author{
Qianyu Dong
}
