% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_bootstrap.r
\name{rds.mc.boot.draws}
\alias{rds.mc.boot.draws}
\title{Draw RDS bootstrap resamples using the
algorithm in Salganik 2006 (see Details below)}
\usage{
rds.mc.boot.draws(chains, mm, dd, num.reps)
}
\arguments{
\item{chains}{A list with the chains constructed from the survey
using \code{make.chain}}

\item{mm}{The mixing model}

\item{dd}{The degree distributions}

\item{num.reps}{The number of bootstrap resamples we want}
}
\value{
A list of length \code{num.reps}; each entry in
the list has one bootstrap-resampled dataset
}
\description{
This algorithm picks a respondent from the survey
to be a seed uniformly at random. it then generates
a bootstrap draw by simulating the markov process
forward for n steps, where n is the size of the draw
required.

If you wish the bootstrap dataset to end up with
variables from the original dataset other than the
traits and degree, then you must specify this when
you construct \code{dd} using the
'\code{estimate.degree.distns} function.
}
\details{
See:
\itemize{
\item Salganik, Matthew J. "Variance estimation, design effects, and sample
size calculations for respondent-driven sampling."
\emph{Journal of Urban Health} 83.1 (2006): 98-112.
}
}
