% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescaled_bootstrap.r
\name{rescaled.bootstrap.sample}
\alias{rescaled.bootstrap.sample}
\title{rescaled.bootstrap.sample}
\usage{
rescaled.bootstrap.sample(
  survey.data,
  survey.design,
  parallel = FALSE,
  paropts = NULL,
  num.reps = 1
)
}
\arguments{
\item{survey.data}{The dataset to use}

\item{survey.design}{A formula describing the design of the survey (see Details)}

\item{parallel}{If \code{TRUE}, use parallelization (via \code{plyr})}

\item{paropts}{An optional list of arguments passed on to \code{plyr} to control
details of parallelization}

\item{num.reps}{The number of bootstrap replication samples to draw}
}
\value{
A list with \code{num.reps} entries. Each entry is a dataset which
has at least the variables \code{index} (the row index of the original
dataset that was resampled) and \code{weight.scale}
(the factor by which to multiply the sampling weights
in the original dataset).
}
\description{
Given a survey dataset and a description of the survey
design (ie, which combination of variables determines primary sampling
units, and which combination of variables determines strata), take
a bunch of bootstrap samples for the rescaled bootstrap estimator
(see Details).
}
\details{
\code{survey.design} is a formula of the form

\code{weight ~ psu_vars + strata(strata_vars)}

where:
\itemize{
\item \code{weight} is the variable with the survey weights
\item \code{psu_vars} has the form \code{psu_v1 + psu_v2 + ...}, where primary
sampling units (PSUs) are determined by \code{psu_v1}, etc
\item \code{strata_vars} has the form \code{strata_v1 + strata_v2 + ...}, which
determine strata
}

Note that we assume that the formula uniquely specifies PSUs.
This will always be true if the PSUs were selected without replacement.
If they were selected with replacement, then it will be necessary
to make each realization of a given PSU in the sample a unique id.
The code below assumes that all observations within
each PSU (as identified by the design formula) are from the same draw
of the PSU.

The rescaled bootstrap technique works by adjusting the
estimation weights based on the number of times each
row is included in the resamples. If a row is never selected,
it is still included in the returned results, but its weight
will be set to 0. It is therefore important to use estimators
that make use of the estimation weights on the resampled
datasets.

We always take m_i = n_i - 1, according to the advice presented
in Rao and Wu (1988) and Rust and Rao (1996).

(This is a C++ version; a previous version, written in pure R,
is called \code{\link[=rescaled.bootstrap.sample.pureR]{rescaled.bootstrap.sample.pureR()}} )

References:
\itemize{
\item Rust, Keith F., and J. N. K. Rao. "Variance estimation for complex surveys
using replication techniques." \emph{Statistical methods in medical research}
5.3 (1996): 283-310.
\item Rao, Jon NK, and C. F. J. Wu. "Resampling inference with complex survey
data." \emph{Journal of the American Statistical Association}
83.401 (1988): 231-241.
}
}
\examples{

survey <- MU284.complex.surveys[[1]]
boot_surveys <- rescaled.bootstrap.sample(survey.data = survey,
                                          survey.design = ~ CL,
                                          num.reps = 2)

}
