% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syllabify.R
\name{syllabify}
\alias{syllabify}
\title{Syllabify}
\usage{
syllabify(pron, alaska_rule = T)
}
\arguments{
\item{pron}{The CMU dictionary pronunciation, either as a vector,
or a string with labels separated by spaces}

\item{alaska_rule}{Don't maximize onset on lax vowel + s sequences}
}
\value{
Returns a data frame with the following columns
\describe{
  \item{syll}{A numeric index for each syllable}
  \item{part}{What part of the syllable each phone belongs to}
  \item{phone}{The phone label from the transcription}
  \item{stress}{The syllable stress}
}
}
\description{
This will take a transcription as input, and return it as a data frame.
}
\examples{
# String input
syllabify("AO0 S T R EY1 L Y AH0")

# Vector input
syllabify(c("AO0", "S", "T", "R", "EY1", "L", "Y", "AH0"))

# Hiatus
syllabify("HH AY0 EY1 T AH0 S")

# Deficient transcriptions (has warning)
syllabify(c("M"))
}
