% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estpoly.R
\name{arx}
\alias{arx}
\title{Estimate ARX Models}
\usage{
arx(x, order = c(1, 1, 1), lambda = 0.1, intNoise = FALSE, fixed = NULL)
}
\arguments{
\item{x}{an object of class \code{idframe}}

\item{order}{Specification of the orders: the three integer components 
(na,nb,nk) are the order of polynolnomial A, (order of polynomial B + 1) and 
the input-output delay}

\item{lambda}{Regularization parameter(Default=\code{0.1})}

\item{intNoise}{Logical variable indicating whether to add integrators in
the noise channel (Default=\code{FALSE})}

\item{fixed}{list containing fixed parameters. If supplied, only \code{NA} entries 
will be varied. Specified as a list of two vectors, each containing the parameters
of polynomials A and B respectively.}
}
\value{
An object of class \code{estpoly} containing the following elements:
 \item{sys}{an \code{idpoly} object containing the 
   fitted ARX coefficients}
 \item{fitted.values}{the predicted response}
 \item{residuals}{the residuals}
 \item{input}{the input data used}
 \item{call}{the matched call}
 \item{stats}{A list containing the following fields: \cr
     \code{vcov} - the covariance matrix of the fitted coefficients \cr
     \code{sigma} - the standard deviation of the innovations\cr
     \code{df} - the residual degrees of freedom}
}
\description{
Fit an ARX model of the specified order given the input-output data
}
\details{
SISO ARX models are of the form 
\deqn{
   y[k] + a_1 y[k-1] + \ldots + a_{na} y[k-na] = b_{nk} u[k-nk] + 
   \ldots + b_{nk+nb} u[k-nk-nb] + e[k] 
}
The function estimates the coefficients using linear least squares (with
regularization).
\cr
The data is expected to have no offsets or trends. They can be removed 
using the \code{\link{detrend}} function. 
\cr
To estimate finite impulse response(\code{FIR}) models, specify the first
order to be zero.
}
\examples{
data(arxsim)
mod_arx <- arx(arxsim,c(1,2,2))
mod_arx
plot(mod_arx) # plot the predicted and actual responses

}
\references{
Arun K. Tangirala (2015), \emph{Principles of System Identification: 
Theory and Practice}, CRC Press, Boca Raton. Section 21.6.1

Lennart Ljung (1999), \emph{System Identification: Theory for the User}, 
2nd Edition, Prentice Hall, New York. Section 10.1
}

