% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssyt.R
\name{ssytx_withGivenShapeAndWeight}
\alias{ssytx_withGivenShapeAndWeight}
\title{Semistandard Young tableaux with given shape and weight}
\usage{
ssytx_withGivenShapeAndWeight(lambda, weight)
}
\arguments{
\item{lambda}{integer partition, the shape}

\item{weight}{integer vector, the weight}
}
\value{
List of all semistandard Young tableaux with shape \code{lambda} 
  and weight \code{weight}.
}
\description{
Enumeration of all semistandard Young tableaux with a given 
  shape and a given weight. The \emph{weight} of a tableau is the 
  vector whose \eqn{i}-th element is the number of occurrences of \eqn{i} 
  in this tableau.
}
\examples{
ssytx <- ssytx_withGivenShapeAndWeight(c(4, 1), c(0, 2, 1, 1, 1))
lapply(ssytx, prettyTableau)
}
\seealso{
\code{\link{all_ssytx}}.
}
