% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_row.R
\name{binary_row}
\alias{binary_row}
\title{Binary Row}
\usage{
binary_row(
  list_obj,
  row_var,
  col_var = NULL,
  newdata = FALSE,
  ref.label = "on",
  rowlabel = NULL,
  summary = NULL,
  reference = NULL,
  compact = TRUE,
  missing = NULL,
  overall = NULL,
  comparison = NULL,
  digits = NULL,
  indent = 5
)
}
\arguments{
\item{list_obj}{the name of the \code{tbl_start} object previously initialized.}

\item{row_var}{the name of the variable to be used in the rows.}

\item{col_var}{the variable to be used in the table columns. Default is from initialized \code{tbl_start} object.}

\item{newdata}{enter new dataset name if different from that initialized in \code{tbl_start}.}

\item{ref.label}{toggles the reference label in the table. Default is \code{on}, which displays the reference; \code{off} switches it off. Only relevant if a compact row is used.}

\item{rowlabel}{the label for the table row name, if different from \code{row_var}.}

\item{summary}{summary function for the data, if different from the one supplied in \code{tbl_start}.}

\item{reference}{the name of the row category to use as the reference. Default will use alphabetical first category.}

\item{compact}{logical: if TRUE, data displayed in one row.}

\item{missing}{logical: if TRUE, missing data is considered; FALSE only uses complete cases.}

\item{overall}{logical: if TRUE, an overall column is included.}

\item{comparison}{the name of the comparison test to use, if different from that initialized in \code{tbl_start}.}

\item{digits}{significant digits to use.}

\item{indent}{number of spaces to indent category names.}
}
\value{
A list with the binary row's table information added as a new element to \code{list_obj}.
}
\description{
Adds in a binary row to a \code{tangram.pipe} table.
}
\examples{
iris$color <- sample(c("Blue", "Purple"), size=150, replace=TRUE)
x <- tbl_start(iris, "Species", missing=TRUE, overall=TRUE, comparison=TRUE) \%>\%
  binary_row("color", rowlabel="Color")
}
\seealso{
Possible summary functions for binary data:\link[tangram.pipe]{binary_default}, \link[tangram.pipe]{binary_pct}, \link[tangram.pipe]{binary_count}, \link[tangram.pipe]{binary_jama}

Other related row-building functions: \link[tangram.pipe]{num_row}, \link[tangram.pipe]{cat_row}, \link[tangram.pipe]{n_row}, \link[tangram.pipe]{empty_row}

Starting a \code{tangram.pipe} table: \link[tangram.pipe]{tbl_start}
}
\keyword{tangram.pipe}
