% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_library.R
\name{get_library_media_info}
\alias{get_library_media_info}
\title{Get A Library's Media Info}
\source{
\url{https://github.com/Tautulli/Tautulli/blob/master/API.md#get_library_media_info}
}
\usage{
get_library_media_info(url = NULL, apikey = NULL, section_id = NULL,
  rating_key = NULL, section_type = "movie", order_column = "added_at",
  order_dir = "desc", start = 0, length = 25, search = NULL)
}
\arguments{
\item{url}{Server URL.}

\item{apikey}{API key.}

\item{section_id}{The id of the Plex library section, OR}

\item{rating_key}{The grandparent or parent rating key}

\item{section_type}{Optional, "movie" (default), "show", "artist", "photo"}

\item{order_column}{Optional, "added_at", "title", "container", "bitrate", "video_codec",
"video_resolution", "video_framerate", "audio_codec", "audio_channels",
"file_size", "last_played", "play_count"}

\item{order_dir}{"desc" (default) or "asc"}

\item{start}{Row to start from, default 0}

\item{length}{Number of items to return, default 25}

\item{search}{A string to search for}
}
\value{
A \code{list} with a \code{totals} list and an \code{items} \code{tbl}
}
\description{
Get A Library's Media Info
}
\examples{
\dontrun{
get_library_media_info(section_id = 2)
}
}
