% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.weekly}
\alias{f.weekly}
\title{Create a Weekly Frequency}
\usage{
f.weekly(date)
}
\arguments{
\item{date}{The date, which can be a list with \code{year}, \code{month}, and \code{day} elements.
It can also be an integer array with 3 elements for year, month, and day respectively,
or an object that can be used as an argument for the \code{base::as.Date} function.
This date determines the start of the week.}
}
\value{
An object of class \code{ldtf}, which is also a list with the following members:
\item{class}{The class of this frequency.}
\item{year}{The \code{year}.}
\item{month}{The \code{month}.}
\item{day}{The \code{day}.}
}
\description{
Use this function to create a frequency for time-series data that occurs weekly. The first day of the week is used as the reference.
}
\details{
To use the \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} The first day of the week in \code{"YYYYMMDD"} format.
\item \strong{Class Id} \code{"w"}
}
}
\examples{

w0 <- f.weekly(c(2023, 1, 2)) # This is 2/1/2023, which is Monday.
#    The next observation belongs to 9/1/2023.

w0_value_str <-  as.character(w0) # this will be '20230102'.
w0_class_str <- get.class.id(w0) # this will be 'w'.

w_new <- as.frequency("20230109", "w") # This is 9/1/2023.

# Don't use invalid or unsupported dates:
\donttest{
w_invalid <- try(as.frequency("1399109", "w")) # this is a too old date and unsupported
w_invalid <- try(as.frequency("20230132", "w")) # invalid day in month
w_invalid <- try(as.frequency("20231331", "w")) # invalid month
}

}
