% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpd.R
\name{gpd}
\alias{gpd}
\alias{dgpd}
\alias{rgpd}
\alias{qgpd}
\alias{pgpd}
\title{The Generalized Pareto Distribution (GPD)}
\usage{
dgpd(x, loc = 0, scale = 1, shape = 0, log.d = FALSE)

rgpd(n, loc = 0, scale = 1, shape = 0)

qgpd(p, loc = 0, scale = 1, shape = 0, lower.tail = TRUE,
  log.p = FALSE)

pgpd(q, loc = 0, scale = 1, shape = 0, lower.tail = TRUE,
  log.p = FALSE)
}
\arguments{
\item{x}{Vector of observations.}

\item{loc, scale, shape}{Location, scale, and shape parameters. Can be vectors, but
the lengths must be appropriate.}

\item{log.d}{Logical; if TRUE, the log density is returned.}

\item{n}{Number of observations.}

\item{p}{Vector of probabilities.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x].}

\item{log.p}{Logical; if TRUE, probabilities p are given as log(p).}

\item{q}{Vector of quantiles.}
}
\description{
Density, distribution function, quantile function and random number generation for the Generalized Pareto
distribution with location, scale, and shape parameters.
}
\details{
The Generalized Pareto distribution function is given (Pickands, 1975)
by \deqn{H(y) = 1 - \Big[1 + \frac{\xi (y - \mu)}{\sigma}\Big]^{-1/\xi}} defined
on \eqn{\{y : y > 0, (1 + \xi (y - \mu) / \sigma) > 0 \}}, with location \eqn{\mu},
scale \eqn{\sigma > 0}, and shape parameter \eqn{\xi}.
}
\examples{
dgpd(2:4, 1, 0.5, 0.01)
dgpd(2, -2:1, 0.5, 0.01)
pgpd(2:4, 1, 0.5, 0.01)
qgpd(seq(0.9, 0.6, -0.1), 2, 0.5, 0.01)
rgpd(6, 1, 0.5, 0.01)

## Generate sample with linear trend in location parameter
rgpd(6, 1:6, 0.5, 0.01)

## Generate sample with linear trend in location and scale parameter
rgpd(6, 1:6, seq(0.5, 3, 0.5), 0.01)

p <- (1:9)/10
pgpd(qgpd(p, 1, 2, 0.8), 1, 2, 0.8)
## [1] 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9

## Incorrect syntax (parameter vectors are of different lengths other than 1)
# rgpd(1, 1:8, 1:5, 0)

## Also incorrect syntax
# rgpd(10, 1:8, 1, 0.01)

}
\references{
Brian Bader, Jun Yan. "eva: Extreme Value Analysis with Goodness-of-Fit Testing." R package version (2016)

Pickands III, J. (1975). Statistical inference using extreme order statistics. Annals of Statistics, 119-131.
}
