% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{print.tunevt}
\alias{print.tunevt}
\title{Print an object of class tunevt}
\usage{
\method{print}{tunevt}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{an object of class \code{tunevt}}

\item{digits}{the number of significant digits to use when printing.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class \code{"tunevt"}.

An object of class \code{"tunevt"} is a list containing at least the
following components:
\item{call}{the matched call}
\item{vtmod}{the model estimated by the given \code{step2} procedure fit
with the permuted tuning parameter for the estimated CATEs from the
\code{step1} model. See \code{\link{vt2_lasso}},
\code{\link{vt2_rtree}}, or \code{\link{vt2_ctree}} for specifics.}
\item{mnpp}{the MNPP for the estimated CATEs from Step 1.}
\item{theta_null}{a vector of the MNPPs from each permutation under
the null hypothesis.}
\item{pvalue}{the probability of observing a MNPP as or more extreme
as the observed MNPP under the null hypothesis of no effect
heterogeneity.}
\item{z}{if \code{keepz = TRUE}, the estimated CATEs from the
\code{step1} model.}
}
\description{
Prints a Virtual Twins model for the conditional average treatment effect
with a tuned Step 2 model.
}
