% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prefilter.R
\name{prefilter}
\alias{prefilter}
\title{Apply the "prefilter" to a Detection Dataframe}
\usage{
prefilter(
  data,
  reference_tags,
  time_unit,
  multipath_time,
  org_ping_rate,
  beacon_ping
)
}
\arguments{
\item{data}{A dataframe which is the output from read_jstats() or
format_detects()}

\item{reference_tags}{A vector of potential reference (beacon) tag IDs}

\item{time_unit}{The unit of time used for analyses (seconds, minutes, hours,
days, weeks, months)}

\item{multipath_time}{A numeric maximum amount of time which must pass
between detections for a detection to be considered a "true", not a bounced,
signal.}

\item{org_ping_rate}{The expected time between transmissions emitted from
tags/transmitters implanted or attached to an organism}

\item{beacon_ping}{The expected time between transmissions emitted from
tags/transmitters used as beacon or reference tags to check receiver
functionality.}
}
\value{
A standardized detection dataframe with multipath detects removed
}
\description{
This function takes a detection dataframe output from format_detects and
filters out multipath signals (signals which are bounced off of surfaces,
usually seen in underwater systems with hard surfaces which reflect sound)
and spurious signals which do not occur within a user defined time frame
of the last detection (12x the ping rate for organisms or 3x the ping rate
for beacons). Following this, the dataframe is standardized so
that all detection dataframes from any technology type are identical and
superfluous fields are removed.
}
\examples{
# Run the prefilter on a set of raw detection data

#format the detection data
detects_formatted <- format_detects(data = raw_detections,
                                    var_Id = "tag_id",
                                    var_datetime_local = "local_time",
                                    var_receiver_serial = "serial",
                                    local_time_zone = "America/Los_Angeles",
                                    time_format = "\%Y-\%m-\%d \%H:\%M:\%S")

#apply the prefilter
prefilter(data = detects_formatted,
          reference_tags = reftags,
          time_unit = "secs",
          multipath_time = 0.3,
          org_ping_rate = 3,
          beacon_ping = 30)
}
