% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/td_independence.R
\name{td_independence}
\alias{td_independence}
\title{Test of independence of terminal digits}
\usage{
td_independence(
  x,
  decimals,
  reps = 10000,
  test = "Chisq",
  tolerance = 64 * .Machine$double.eps
)
}
\arguments{
\item{x}{a numeric vector}

\item{decimals}{an integer specifying the number of decimals. This can be zero if the terminal digit is
not a decimal.}

\item{reps}{a positive integer specifying the number of Monte Carlo simulations. The default
is set to 10,000 which may be appropriate for exploratory analysis. A higher
number of simulation should be selected for more precise results.}

\item{test}{a string specifying the test of independence. The default is Pearson's
chi-squared statistic ("Chisq"). Also available is the log-likelihood ratio
statistic ("G2"), the Freeman-Tukey statistic ("FT"), and the Root-mean-square
statistic ("RMS").}

\item{tolerance}{sets an upper bound for rounding errors when evaluating
whether a statistic for a simulation is greater than or equal to the
statistic for the observed data. The default is identical to the tolerance
set for simulations in the \code{chisq.test} function from the \code{stats}
package in R.}
}
\value{
A list with class "htest" containing the following components:

\item{statistic}{the value of the test statistic}
\item{p_value}{the simulated p-value for the test}
\item{method}{a character string describing the test}
\item{data.name}{a character string give the name of the data}
}
\description{
The \code{td_independence} function tests the independence of terminal digits from
preceding digits by constructing a contingency table of counts where rows constitute
unique preceding digits and columns constitute unique terminal digits. A test of
independence for a contingency tables is then implemented via Monte Carlo
simulation.
}
\details{
Monte Carlo simulations are implemented for contingency tables with fixed
margins using algorithm ASA 144 (Agresti, Wackerly, and Boyett, 1979; Boyett 1979).
}
\examples{

td_independence(decoy$weight, decimals = 2, reps = 2000)

}
\references{
Agresti, A., Wackerly, D., & Boyett, J. M. (1979). Exact conditional tests
for cross-classifications: approximation of attained significance levels.
Psychometrika, 44(1), 75-83.

Boyett, J. M. (1979). Algorithm AS 144: Random r × c tables with
given row and column totals. Journal of the Royal Statistical Society.
Series C (Applied Statistics), 28(3), 329-332.
}
