% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{siris_queries}
\alias{siris_queries}
\title{SDG queries of SIRIS Academic}
\format{
A data frame with 3,445 rows and 6 columns
\describe{
  \item{system}{Name of system}
  \item{sdg}{Label of the SDG}
  \item{keyword}{Primary SDG query element}
  \item{extra}{Secodary SDG query element}
  \item{query_id}{Index of the query}
  \item{query}{SDG query}
}
}
\source{
\url{https://zenodo.org/record/3567769#.YVMhH9gzYUG}
}
\usage{
siris_queries
}
\description{
A dataset containing the SDG queries of \href{https://www.sirislab.com/lab/sdg-research-mapping/}{SIRIS Academic}. The queries are available from\href{https://zenodo.org/record/3567769#.YRY9xdMzY8N}{Zenodo.org}. The SIRIS queries were developed by extracting key terms from the UN official list of goals, targets and indicators as well from relevant literature around SDGs. The query system has subsequently been expanded with a pre-trained word2vec model and an algorithm that selects related words from Wikipedia. There are multiple queries per SDG (one per row). There are no queries for SDG-17.
}
\keyword{datasets}
