% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.table.R
\name{ngrams}
\alias{ngrams}
\title{Create n-grams}
\usage{
ngrams(
  x,
  text,
  group_by = c(),
  count_col_name = "count",
  n,
  ngram_prefix = NULL
)
}
\arguments{
\item{x}{A text.table created by as.text.table().}

\item{text}{A string, the name of the column in x to build n-grams with.}

\item{group_by}{A vector of column names to group by. Doesn't work if the group by column is a list column.}

\item{count_col_name}{A string, the name of the output column containing the number of times each base record appears in the group.}

\item{n}{A integer, the number of grams to make.}

\item{ngram_prefix}{A string, a prefix to add to the output n-gram columns.}
}
\value{
A text.table, with columns added for n-grams (the word, the count, and percent of the time the gram follows the word).
}
\description{
Create n-grams
}
\examples{
ngrams(
as.text.table(
  x = as.data.table(
    list(
      col1 = c(
        "a",
        "b"
      ),
      col2 = c(
        tolower("The dog is nice because it picked up the newspaper."),
        tolower("The dog is extremely nice because it does the dishes.")
      )
    )
  ),
  text = "col2",
  split = " "
),
text = "col2",
group_by = "col1",
n = 2
)
}
