% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sem_nearest_neighbors.R
\name{sem_nearest_neighbors}
\alias{sem_nearest_neighbors}
\title{Find Nearest Neighbors Based on Cosine Similarity}
\usage{
sem_nearest_neighbors(x, matrix, n = 10)
}
\arguments{
\item{x}{A character or numeric vector representing the term or vector.}

\item{matrix}{A numeric matrix or a sparse matrix against which the similarity is calculated.}

\item{n}{Number of nearest neighbors to return.}
}
\value{
A data frame with the ranks, terms, and their cosine similarity scores.
}
\description{
This function identifies the nearest neighbors of a given term or vector
in a matrix based on cosine similarity.
}
\examples{
\dontrun{
 api_token <- ''
 matrix <- api_huggingface_embeddings(tif,
                                      text_hierarchy = c('doc_id', 'sentence_id'),
                                      api_token = api_token)
 query <- api_huggingface_embeddings(query = "Where's the party at?",
                                     api_token = api_token)
 neighbors <- sem_nearest_neighbors(x = query, matrix = matrix)
}



}
