% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TextReuseCorpus.R
\name{TextReuseCorpus}
\alias{TextReuseCorpus}
\alias{is.TextReuseCorpus}
\alias{skipped}
\title{TextReuseCorpus}
\usage{
TextReuseCorpus(
  paths,
  dir = NULL,
  text = NULL,
  meta = list(),
  progress = interactive(),
  tokenizer = tokenize_ngrams,
  ...,
  hash_func = hash_string,
  minhash_func = NULL,
  keep_tokens = FALSE,
  keep_text = TRUE,
  skip_short = TRUE
)

is.TextReuseCorpus(x)

skipped(x)
}
\arguments{
\item{paths}{A character vector of paths to files to be opened.}

\item{dir}{The path to a directory of text files.}

\item{text}{A character vector (possibly named) of documents.}

\item{meta}{A list with named elements for the metadata associated with this
corpus.}

\item{progress}{Display a progress bar while loading files.}

\item{tokenizer}{A function to split the text into tokens. See
\code{\link{tokenizers}}. If value is \code{NULL}, then tokenizing and
hashing will be skipped.}

\item{...}{Arguments passed on to the \code{tokenizer}.}

\item{hash_func}{A function to hash the tokens. See
\code{\link{hash_string}}.}

\item{minhash_func}{A function to create minhash signatures of the document.
See \code{\link{minhash_generator}}.}

\item{keep_tokens}{Should the tokens be saved in the documents that are
returned or discarded?}

\item{keep_text}{Should the text be saved in the documents that are returned
or discarded?}

\item{skip_short}{Should short documents be skipped? (See details.)}

\item{x}{An R object to check.}
}
\description{
This is the constructor function for a \code{TextReuseCorpus}, modeled on the
virtual S3 class \code{\link[tm]{Corpus}} from the \code{tm} package. The
object is a \code{TextReuseCorpus}, which is basically a list containing
objects of class \code{\link{TextReuseTextDocument}}. Arguments are passed
along to that constructor function. To create the corpus, you can pass either
a character vector of paths to text files using the \code{paths =} parameter,
a directory containing text files (with any extension) using the \code{dir =}
parameter, or a character vector of documents using the \code{text = }
parameter, where each element in the characer vector is a document. If the
character vector passed to \code{text = } has names, then those names will be
used as the document IDs. Otherwise, IDs will be assigned to the documents.
Only one of the \code{paths}, \code{dir}, or \code{text} parameters should be
specified.
}
\details{
If \code{skip_short = TRUE}, this function will skip very short or
  empty documents. A very short document is one where there are two few words
  to create at least two n-grams. For example, if five-grams are desired,
  then a document must be at least six words long. If no value of \code{n} is
  provided, then the function assumes a value of \code{n = 3}. A warning will
  be printed with the document ID of each skipped document. Use
  \code{skipped()} to get the IDs of skipped documents.

  This function will use multiple cores on non-Windows machines if the
  \code{"mc.cores"} option is set. For example, to use four cores:
  \code{options("mc.cores" = 4L)}.
}
\examples{
dir <- system.file("extdata/legal", package = "textreuse")
corpus <- TextReuseCorpus(dir = dir, meta = list("description" = "Field Codes"))
# Subset by position or file name
corpus[[1]]
names(corpus)
corpus[["ca1851-match"]]

}
\seealso{
\link[=TextReuseTextDocument-accessors]{Accessors for TextReuse
  objects}.
}
