% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{loss_hamming}
\alias{loss_hamming}
\title{Hamming loss}
\usage{
loss_hamming(
  mode,
  name = "hamming_loss",
  threshold = NULL,
  dtype = tf$float32,
  ...
)
}
\arguments{
\item{mode}{multi-class or multi-label}

\item{name}{(optional) String name of the metric instance.}

\item{threshold}{Elements of `y_pred` greater than threshold are converted to be 1,
and the rest 0. If threshold is None, the argmax is converted to 1, and the rest 0.}

\item{dtype}{(optional) Data type of the metric result. Defaults to `tf$float32`.}

\item{...}{additional arguments that are passed on to function `fn`.}
}
\value{
hamming loss: float
}
\description{
Computes hamming loss.
}
\details{
Hamming loss is the fraction of wrong labels to the total number of labels.
In multi-class classification, hamming loss is calculated as the hamming distance
between `actual` and `predictions`. In multi-label classification, hamming loss
penalizes only the individual labels.
}
\examples{
\dontrun{

# multi-class hamming loss
hl = loss_hamming(mode='multiclass', threshold=0.6)
actuals = tf$constant(list(as.integer(c(1, 0, 0, 0)),as.integer(c(0, 0, 1, 0)),
                       as.integer(c(0, 0, 0, 1)),as.integer(c(0, 1, 0, 0))),
                      dtype=tf$float32)
predictions = tf$constant(list(c(0.8, 0.1, 0.1, 0),
                           c(0.2, 0, 0.8, 0),
                           c(0.05, 0.05, 0.1, 0.8),
                           c(1, 0, 0, 0)),
                          dtype=tf$float32)
hl$update_state(actuals, predictions)
paste('Hamming loss: ', hl$result()$numpy()) # 0.25
# multi-label hamming loss
hl = loss_hamming(mode='multilabel', threshold=0.8)
actuals = tf$constant(list(as.integer(c(1, 0, 1, 0)),as.integer(c(0, 1, 0, 1)),
                       as.integer(c(0, 0, 0,1))), dtype=tf$int32)
predictions = tf$constant(list(c(0.82, 0.5, 0.90, 0),
                           c(0, 1, 0.4, 0.98),
                           c(0.89, 0.79, 0, 0.3)),
                          dtype=tf$float32)
hl$update_state(actuals, predictions)
paste('Hamming loss: ', hl$result()$numpy()) # 0.16666667

}

}
