% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers.R
\name{optimizer_conditional_gradient}
\alias{optimizer_conditional_gradient}
\title{Conditional Gradient}
\usage{
optimizer_conditional_gradient(
  learning_rate,
  lambda_,
  epsilon = 1e-07,
  use_locking = FALSE,
  name = "ConditionalGradient",
  clipnorm = NULL,
  clipvalue = NULL,
  decay = NULL,
  lr = NULL
)
}
\arguments{
\item{learning_rate}{A Tensor or a floating point value, or a schedule that is a tf$keras$optimizers$schedules$LearningRateSchedule The learning rate.}

\item{lambda_}{A Tensor or a floating point value. The constraint.}

\item{epsilon}{A Tensor or a floating point value. A small constant for numerical stability when handling the case of norm of gradient to be zero.}

\item{use_locking}{If True, use locks for update operations.}

\item{name}{Optional name prefix for the operations created when applying gradients. Defaults to 'ConditionalGradient'.}

\item{clipnorm}{is clip gradients by norm.}

\item{clipvalue}{is clip gradients by value.}

\item{decay}{is included for backward compatibility to allow time inverse decay of learning rate.}

\item{lr}{is included for backward compatibility, recommended to use learning_rate instead.}
}
\value{
Optimizer for use with `keras::compile()`
}
\description{
Conditional Gradient
}
