% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq2seq.R
\name{safe_cumprod}
\alias{safe_cumprod}
\title{Safe cumprod}
\usage{
safe_cumprod(x, ...)
}
\arguments{
\item{x}{Tensor to take the cumulative product of.}

\item{...}{Passed on to cumsum; these are identical to those in cumprod}
}
\value{
Cumulative product of x.
}
\description{
Computes cumprod of x in logspace using cumsum to avoid underflow.
}
\details{
The cumprod function and its gradient can result in numerical instabilities
when its argument has very small and/or zero values. As long as the
argument is all positive, we can instead compute the cumulative product as
exp(cumsum(log(x))). This function can be called identically to
tf$cumprod.
}
