% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrow_dataset.R
\name{arrow_stream_dataset}
\alias{arrow_stream_dataset}
\title{Creates a \code{ArrowStreamDataset}.}
\usage{
arrow_stream_dataset(host, columns, output_types, output_shapes = NULL)
}
\arguments{
\item{host}{A \code{tf.string} tensor or string defining the input stream.
For a socket client, use "<HOST_IP>:<PORT>", for stdin use "STDIN".}

\item{columns}{A list of column indices to be used in the Dataset.}

\item{output_types}{Tensor dtypes of the output tensors.}

\item{output_shapes}{TensorShapes of the output tensors or \code{NULL} to infer
partial.}
}
\description{
An Arrow Dataset for reading record batches from an input stream. Currently
supported input streams are a socket client or stdin.
}
\examples{
\dontrun{
dataset <- arrow_stream_dataset(
    host,
    columns = reticulate::tuple(0L, 1L),
    output_types = reticulate::tuple(tf$int32, tf$float32),
    output_shapes = reticulate::tuple(list(), list())) \%>\%
  dataset_repeat(1)

sess <- tf$Session()
iterator <- make_iterator_one_shot(dataset)
next_batch <- iterator_get_next(iterator)

until_out_of_range({
  batch <- sess$run(next_batch)
  print(batch)
})
}

}
