% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate Data from DAG}
\usage{
simulate_data(
  x,
  beta_default = round(runif(1, min = -0.6, max = 0.6), 2),
  n = 500,
  run = TRUE,
  duplicated = "unique"
)
}
\arguments{
\item{x}{An object of class \code{dagitty}.}

\item{beta_default}{Function used to specify missing edge coefficients.
Default: \code{runif(1, min = -0.6, max = 0.6)}}

\item{n}{Atomic integer defining the sample size, default: \code{500}}

\item{run}{Logical, indicating whether or not to run the simulation. Default:
\code{TRUE}.}

\item{duplicated}{Atomic character, indicating how to resolve duplicate terms
from multiple edges pointing to the same node. Default: \code{"unique"}. See
Details.}
}
\value{
If \code{run} is \code{TRUE}, this function returns a \code{data.frame} with
an additional attribute called \code{attr( , which = "script")} that contains the
script for simulating data. If \code{run} is \code{FALSE}, this function returns the
script as \code{character} vector.
}
\description{
Simulates data from an (augmented) DAG, respecting the optional
metadata fields \code{form}, for functional form of relationships, and
\code{distribution}, for the distributions of exogenous nodes and
residuals.
}
\details{
Data is simulated sequentially, first from exogenous nodes and then
from their descendants. If \code{x} is an augmented DAG with metadata indicating
the functional \code{form} of relationships and \code{distribution} of exogenous nodes
and residuals, this information is used. If this information is absent, nodes
and residuals are assumed to be normally distributed, and edges are assumed
to be linear, with coefficients samples based on \code{beta_default}.

The argument \code{duplicated} controls how multiplicative terms are merged across
edges pointing to the same outcome node. The default \code{duplicated = "unique"}
removes terms that are duplicated across edges (i.e.,
if two edges point to node \code{"O"}, and both edges specify \code{.5*E}, the resulting
function will say \code{.5*E}. However, if one edge specifies \code{.2*E} and the other
specifies \code{.3*E}, they are not duplicated and will be added.
Alternatively, \code{duplicated = "add"} just sums terms across all edges pointing
into the same outcome node.
}
\examples{
x <- dagitty::dagitty('
dag {
  X [distribution="rbinom(size = 2, prob = .5)"]
  Z [distribution="rexp()"]
  Y [distribution="rnorm()"]

  X -> Y [form="0.5+X"]
  Z -> Y [form="2*Z"]
  A -> X
}
')
txt <- simulate_data(x, n = 5, run = FALSE)
df <- simulate_data(x, n = 5, run = TRUE)
df_from_txt <- eval(parse(text = txt))
}
\seealso{
\code{\link[tidySEM]{get_nodes}}, \code{\link[tidySEM]{get_edges}}
\code{\link[dagitty]{exogenousVariables}}
}
