% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tsaggregates.R
\name{plot.tsaggregates}
\alias{plot.tsaggregates}
\alias{autoplot.tsaggregates}
\title{Plot time series aggregates}
\usage{
\method{plot}{tsaggregates}(x, series = "all", ...)

\method{autoplot}{tsaggregates}(object, series = "all", ...)
}
\arguments{
\item{x}{\code{tsaggregates} object, produced by \code{\link{tsaggregates}}.}

\item{series}{The indexes of the series to plot. By default, all series are plotted.}

\item{...}{Other arguments passed to \code{\link[stats]{plot.ts}}
or \code{\link[forecast]{autoplot.ts}}.}

\item{object}{\code{tsaggregates} object, produced by \code{\link{tsaggregates}}.}
}
\description{
Plots all temporal aggregations of a time series
}
\examples{
deathagg <- tsaggregates(USAccDeaths)
plot(deathagg, series=c(1,2,4,6))

library(ggplot2)
autoplot(deathagg)

}
\author{
Rob J Hyndman
}
