% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TIRTfit-methods.R
\name{gof.TIRTfit}
\alias{gof.TIRTfit}
\alias{gof}
\title{Extract corrected goodness of fit statistics}
\usage{
\method{gof}{TIRTfit}(object, ...)

gof(object, ...)
}
\arguments{
\item{object}{A \code{TIRTfit} object.}

\item{...}{currently unused.}
}
\value{
A vector containing the chi-square value, adjusted degrees of
  freedom, p-value, and RMSEA.
}
\description{
By default \pkg{lavaan} will return a value for degrees of
freedom that ignores redundancies amongst the estimated model
thresholds. This function corrects the degrees of freedom, and
then recalculates the associated chi-square test statistic
p-value and root mean square error of approximation (RMSEA).
}
\details{
Note this function is currently only implemented for \pkg{lavaan}.
}
\examples{
# load the data
data("triplets")

# define the blocks of items
blocks <-
  set_block(c("i1", "i2", "i3"), traits = c("t1", "t2", "t3"),
            signs = c(1, 1, 1)) +
  set_block(c("i4", "i5", "i6"), traits = c("t1", "t2", "t3"),
            signs = c(-1, 1, 1)) +
  set_block(c("i7", "i8", "i9"), traits = c("t1", "t2", "t3"),
            signs = c(1, 1, -1)) +
  set_block(c("i10", "i11", "i12"), traits = c("t1", "t2", "t3"),
            signs = c(1, -1, 1))

# generate the data to be understood by 'thurstonianIRT'
triplets_long <- make_TIRT_data(
  data = triplets, blocks = blocks, direction = "larger",
  format = "pairwise", family = "bernoulli", range = c(0, 1)
)

# fit the data using lavaan
fit <- fit_TIRT_lavaan(triplets_long)
gof(fit)

}
