% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidydelta.R
\name{tidydelta}
\alias{tidydelta}
\title{Delta Method implementation}
\usage{
tidydelta(
  formula,
  normality_eval = TRUE,
  formula_vars = mean,
  mean_dta = NULL,
  cov_dta = NULL,
  n = NULL,
  conf_lev = 0.95
)
}
\arguments{
\item{formula}{A formula object specifying the variables of interest.}

\item{normality_eval}{Logical value to run normality test in case of being
possible.}

\item{formula_vars}{The function(s) to apply to the variables in the formula.}

\item{mean_dta}{Vector containing the means of the variables.}

\item{cov_dta}{Covariance matrix of the variables.}

\item{n}{Sample size evaluation (in case that we can evaluate the confidence
intervals with different hypnotic sample sizes).}

\item{conf_lev}{Confidence level for confidence intervals.}
}
\value{
A tibble with columns for means, standard errors, and optionally,
confidence intervals.
}
\description{
Estimates standard errors for transformations of random variables
using Delta method.
}
\examples{
# Equivalent ways to use tidydelta()
library(tidyverse)

x <- rnorm(1000, mean = 5, sd = 2)
y <- rnorm(1000, mean = 15, sd = 3)

bd <- tibble(x, y)

tidydelta(~ y / x,
  conf_lev = .95
)

tidydelta(~ bd$y / bd$x,
  conf_lev = .95
)
bd \%>\%
  summarise(tidydelta(~ y / x,
    conf_lev = .95
  ))

}
