% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_model.R
\name{get_tidyFit}
\alias{get_tidyFit}
\title{Get a tidyFit model from a tidyfit.models frame}
\usage{
get_tidyFit(df, ..., .first_row = TRUE)
}
\arguments{
\item{df}{a tidyfit.models frame created using m(), regress(), classify() and similar methods}

\item{...}{arguments passed to \code{dplyr::filter} to filter row in 'df' for which the model should be returned. filters can also include columns nested in \code{df$settings}.}

\item{.first_row}{should the first row be returned if the (filtered) df contains multiple rows}
}
\value{
An object of the class associated with the underlying fitting algorithm
}
\description{
Returns a single tidyFit object from a tidyfit.models frame based on a given row number.
}
\details{
This method is a utility to return the tidyFit object from a row index of the tidyfit.models frame. The tidyFit object contains the fitted model and several additional objects necessary to reproduce the analysis or refit the model on new data.
}
\examples{
# Load data
data("mtcars")

# fit separate models for transmission types
mtcars <- dplyr::group_by(mtcars, am)

fit <- regress(mtcars, mpg ~ ., m("lm"))

# get the model for single row
get_tidyFit(fit, am == 0)

# get model by row number
get_tidyFit(fit, dplyr::row_number() == 2)

}
\seealso{
\code{\link{get_model}} method
}
\author{
Johann Pfitzinger
}
