% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rroc.R
\name{calculate_rroc}
\alias{calculate_rroc}
\title{Regression ROC Curve calculation}
\usage{
calculate_rroc(label, prediction, nbins = 100)
}
\arguments{
\item{label}{True label}

\item{prediction}{Model prediction of the label (out of sample)}

\item{nbins}{Number of shift values to sweep over}
}
\value{
A tibble with \code{nbins} rows.
}
\description{
This function calculates the RegressionROC Curve of
of Hernández-Orallo
\doi{doi:10.1016/j.patcog.2013.06.014}.
It provides estimates for the positive and negative
errors when predictions are shifted by a variety
of constants (which range across the domain of observed
residuals). Curves closer to the axes are, in general, to be
preferred. In general, this curve provides a simple way to
visualize the error properties of a regression model.
}
\details{
The dot shows the errors when no shift is applied, corresponding
to the base model predictions.
}
\references{
Hernández-Orallo, J. (2013). ROC curves for regression.
Pattern Recognition, 46(12), 3395-3411.
}
\keyword{internal}
