% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporal-aggregation.R
\name{temporal_aggregate}
\alias{temporal_aggregate}
\alias{temporal_rolling_window}
\title{The temporal processing module}
\usage{
temporal_aggregate(data, ...)

temporal_rolling_window(
  var,
  scale,
  .before = 0L,
  .step = 1L,
  .complete = TRUE,
  rm.na = TRUE,
  ...
)
}
\arguments{
\item{data}{an index table object, see [tidyindex::init()]}

\item{...}{an temporal processing object of class \code{temporal_agg}}

\item{var}{the variable to aggregate}

\item{scale}{numeric, the scale (window) of the aggregation}

\item{.before, .step, .complete}{see \code{\link[slider]{slide_dbl}}}

\item{rm.na}{logical, whether to remove the first few rows with NAs}
}
\value{
an index table object
}
\description{
The temporal processing module is used to aggregate data along the temporal
dimension. Current available aggregation recipe includes
 \code{temporal_rolling_window}.
}
\examples{
tenterfield |>
  init(time = ym) |>
  temporal_aggregate(.agg = temporal_rolling_window(prcp, scale = 12))

# multiple ids (groups), and multiple scales
queensland |>
  dplyr::filter(id \%in\% c("ASN00029038", "ASN00029127")) |>
  init(id = id, time = ym) |>
  temporal_aggregate(temporal_rolling_window(prcp, scale = c(12, 24)))
}
