% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidymodlr-package.R
\docType{package}
\name{tidymodlr-package}
\alias{tidymodlr}
\alias{tidymodlr-package}
\title{\code{tidymodlr}: Modelling with tidy long data}
\description{
\code{tidymodlr} transforms long data into a matrix form to allow for ease
of input into modelling packages for regression, principal components,
imputation or machine learning.
}
\details{
In many fields it is common to have data in tidy long data, with
the rows representing many variables, but only \strong{one}
column representing the values (see \code{?wb} for an example).

\code{tidymodlr} is particularly useful when the indicator names in the
columns are long descriptive strings, for example
'Energy imports, net (\% of energy use)'.
In such cases a straight \verb{pivot wider} generates column names that are
not only cumbersome, but also generate errors in many standard
modelling packages that require \code{base} column names.

High level analysis functions for correlation, imputation and principals
components analysis are provided.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/david-hammond/tidymodlr}
  \item Report bugs at \url{https://github.com/david-hammond/tidymodlr/issues}
}

}
\author{
\strong{Maintainer}: David Hammond \email{anotherdavidhammond@gmail.com}

}
