% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_loci.R
\name{augment_loci}
\alias{augment_loci}
\title{Augment the loci table with information from a analysis object}
\usage{
augment_loci(x, data, ...)
}
\arguments{
\item{x}{An object returned by one of the \code{gt_} functions (e.g. \code{\link[=gt_pca]{gt_pca()}}).}

\item{data}{the \code{gen_tibble} used to run the PCA.}

\item{...}{Additional parameters passed to the individual methods.}
}
\value{
A loci tibble with additional columns. If \code{data} is missing, a tibble
of the information, with a column \code{.rownames} giving the loci names.
}
\description{
\code{augment_loci} add columns to the loci table of a \code{gen_tibble} related to
information from a given analysis.
}
\examples{
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
lobsters <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Remove monomorphic loci and impute
lobsters <- lobsters \%>\% select_loci_if(loci_maf(genotypes) > 0)
lobsters <- gt_impute_simple(lobsters, method = "mode")

# Create PCA
pca <- gt_pca_partialSVD(lobsters)

# Augment the gen_tibble with the PCA scores
augment_loci(pca, data = lobsters)

}
