% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_resample.R
\name{start_resample}
\alias{start_resample}
\title{Specify a resampling scheme for start_data}
\usage{
start_resample(
  start_data,
  n = NULL,
  inv_noise_scale = NULL,
  support = c("observed", "all")
)
}
\arguments{
\item{start_data}{A \code{data.frame}}

\item{n}{An optional integer sample size. If unspecified, \code{n = nrow(start_data)}}

\item{inv_noise_scale}{An optional parameter to set randomized noise to the proportions
of records with different \code{start_data} characteristics. Corresponds to a privacy loss
budget under epsilon differential privacy.}

\item{support}{A string that specifies the method of resampling from the \code{start_data}
domain.}
}
\value{
A \code{start_method} object for resampling starting data
}
\description{
Specify a resampling scheme for start_data
}
\examples{
 
 
start_method(
  start_func = start_resample, n = 1000
)
 
}
