% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spanning_headers.R
\name{spanning_headers}
\alias{spanning_headers}
\title{Spanning headers for outputs}
\usage{
spanning_headers(column_metadata)
}
\arguments{
\item{column_metadata}{dataframe containing the column metadata that is
passed to \code{tlgsetup()} (see \code{tlgsetup()} for details)}
}
\value{
List of character vectors containing column headers for an output.
}
\description{
This will create the list object to be passed to \code{gentlg()} You can create as
many spanning headers as you like, just add variables prefixed with span to
the column metadata.
}
\examples{
column_metadata <-
  tibble::tribble(
    ~tbltype, ~coldef, ~decode,                ~span1,
    "type1",  "0",     "Placebo",              "",
    "type1",  "54",    "Low Dose",             "Xanomeline",
    "type1",  "81",    "High Dose",            "Xanomeline",
    "type1",  "54+81", "Total Xanomeline",     ""
  )

spanning_headers(column_metadata)
}
