% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_analysis_multi.R
\name{param_trend_multi}
\alias{param_trend_multi}
\title{Tendencia para varios parametros (filtro por rio/ponto)}
\usage{
param_trend_multi(df, parametros, rios = NULL, pontos = NULL, na_rm = TRUE)
}
\arguments{
\item{df}{Data frame com \code{data} e colunas dos parametros.}

\item{parametros}{Vetor de nomes de parametros.}

\item{rios}{Vetor de rios (opcional; usa coluna \code{rio} se existir).}

\item{pontos}{Vetor de pontos (opcional; usa coluna \code{ponto} se existir).}

\item{na_rm}{Logical; repassado para \code{param_trend()}.}
}
\value{
Tibble combinando as tendencias de todos os parametros,
com coluna \code{parametro}.
}
\description{
Itera sobre um vetor de \code{parametros}, chamando \code{param_trend()} para cada um,
e combina as saidas em uma unica tabela, acrescentando a coluna \code{parametro}.
}
\examples{
\dontrun{
data("wq_demo", package = "tikatuwq")
param_trend_multi(wq_demo, c("turbidez","od"), pontos = "P1")
}
}
\seealso{
Other parameter-tools: 
\code{\link{param_plot}()},
\code{\link{param_plot_multi}()},
\code{\link{param_summary}()},
\code{\link{param_summary_multi}()},
\code{\link{param_trend}()}
}
\concept{parameter-tools}
