% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{db_collection_list}
\alias{db_collection_list}
\title{List All Available Collections for a Specific User}
\usage{
db_collection_list(con, user = Sys.info()["user"], schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{user}{character name of the database user. Defaults to the user of the R session.
this is often the user for the database, too so you do not have to specify
your username explicitly if that is the case.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
List All Available Collections for a Specific User
}
\examples{

\dontrun{
ts1 <- list(ts(rnorm(100), start = c(1990, 1), frequency = 4))
names(ts1) <- c("ts1")
db_ts_store(con = connection, ts1, schema = "schema")
db_ts_store(con = connection, zrh_airport, schema = "schema")
db_ts_store(con = connection, kof_ts, schema = "schema")

db_collection_add_ts(
  con = connection,
  collection_name = "barometer and departures zurich",
  ts_keys = c(
    "ch.zrh_airport.departure.total",
    "ch.zrh_airport.departure.total",
    "ch.kof.barometer"
  ),
  schema = "schema"
)

db_collection_add_ts(
  con = connection,
  collection_name = "ts1 and departures zurich",
  ts_keys = c(
    "ch.zrh_airport.departure.total",
    "ts1"
  ),
  schema = "schema"
)

db_collection_list(
  con = connection,
  schema = "schema"
)
}
}
\seealso{
Other collections functions: 
\code{\link{db_collection_add_ts}()},
\code{\link{db_collection_delete}()},
\code{\link{db_collection_get_keys}()},
\code{\link{db_collection_get_last_update}()},
\code{\link{db_collection_remove_ts}()}
}
\concept{collections functions}
