% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{db_dataset_delete}
\alias{db_dataset_delete}
\title{Irrevocably Delete All Time Series in a Set and the Set Itself}
\usage{
db_dataset_delete(con, set_name, schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{set_name}{\strong{character} name of a dataset.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
character name of the deleted set, NA in case of an error.
}
\description{
This function cannot be used in batch mode as it needs user interaction.
It asks the user to manually input confirmation to prevent
unintentional deletion of datasets.
}
\examples{

\dontrun{

db_dataset_create(
  con = connection,
  set_name = "zrh_airport_data",
  set_description = "Zurich airport arrivals and departures ",
  schema = "schema"
)

db_dataset_delete(
  con = connection,
  set_name = "zrh_airport_data",
  schema = "schema"
)
}
}
\seealso{
Other datasets functions: 
\code{\link{db_dataset_create}()},
\code{\link{db_dataset_get_keys}()},
\code{\link{db_dataset_get_last_update}()},
\code{\link{db_dataset_list}()},
\code{\link{db_dataset_trim_history}()},
\code{\link{db_dataset_update_metadata}()},
\code{\link{db_ts_assign_dataset}()},
\code{\link{db_ts_get_dataset}()}
}
\concept{datasets functions}
