% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_tt.R, R/zzz-aliases.R
\name{format_tt}
\alias{format_tt}
\alias{tt_format}
\title{Format columns of a data frame}
\usage{
format_tt(
  x,
  i = NULL,
  j = NULL,
  digits = get_option("tinytable_format_digits", default = NULL),
  num_fmt = get_option("tinytable_format_num_fmt", default = "significant"),
  num_zero = get_option("tinytable_format_num_zero", default = FALSE),
  num_suffix = get_option("tinytable_format_num_suffix", default = FALSE),
  num_mark_big = get_option("tinytable_format_num_mark_big", default = ""),
  num_mark_dec = get_option("tinytable_format_num_mark_dec", default =
    getOption("OutDec", default = ".")),
  date = get_option("tinytable_format_date", default = NULL),
  bool = get_option("tinytable_format_bool", default = NULL),
  math = get_option("tinytable_format_math", default = FALSE),
  other = get_option("tinytable_format_other", default = NULL),
  replace = get_option("tinytable_format_replace", default = FALSE),
  escape = get_option("tinytable_format_escape", default = FALSE),
  markdown = get_option("tinytable_format_markdown", default = FALSE),
  quarto = get_option("tinytable_format_quarto", default = FALSE),
  fn = get_option("tinytable_format_fn", default = NULL),
  sprintf = get_option("tinytable_format_sprintf", default = NULL),
  linebreak = get_option("tinytable_format_linebreak", default = NULL),
  output = get_option("tinytable_format_output", default = NULL)
)

tt_format(
  x,
  i = NULL,
  j = NULL,
  digits = get_option("tinytable_format_digits", default = NULL),
  num_fmt = get_option("tinytable_format_num_fmt", default = "significant"),
  num_zero = get_option("tinytable_format_num_zero", default = FALSE),
  num_suffix = get_option("tinytable_format_num_suffix", default = FALSE),
  num_mark_big = get_option("tinytable_format_num_mark_big", default = ""),
  num_mark_dec = get_option("tinytable_format_num_mark_dec", default =
    getOption("OutDec", default = ".")),
  date = get_option("tinytable_format_date", default = NULL),
  bool = get_option("tinytable_format_bool", default = NULL),
  math = get_option("tinytable_format_math", default = FALSE),
  other = get_option("tinytable_format_other", default = NULL),
  replace = get_option("tinytable_format_replace", default = FALSE),
  escape = get_option("tinytable_format_escape", default = FALSE),
  markdown = get_option("tinytable_format_markdown", default = FALSE),
  quarto = get_option("tinytable_format_quarto", default = FALSE),
  fn = get_option("tinytable_format_fn", default = NULL),
  sprintf = get_option("tinytable_format_sprintf", default = NULL),
  linebreak = get_option("tinytable_format_linebreak", default = NULL),
  output = get_option("tinytable_format_output", default = NULL)
)
}
\arguments{
\item{x}{A data frame or a vector to be formatted.}

\item{i}{Numeric vector or string.
\itemize{
\item Numeric vector: Row indices where the styling should be applied. Can be a single value or a vector.
\item String: Table components to format "caption", "colnames", "groupi" (row group labels), "~groupi" (non-group rows), "groupj" (column group labels), "notes".
\item If both the \code{i} and \code{j} are omitted (default: NULL), formatting is applied to all table elements, including caption, notes, and group labels.
}}

\item{j}{Column indices where the styling should be applied. Can be:
\itemize{
\item Integer vectors indicating column positions.
\item Character vector indicating column names.
\item A single string specifying a Perl-style regular expression used to match column names.
\item Unquoted expression: Non-standard evaluation is supported. When supplying an unquoted expression, it is first evaluated in the calling environment, then in an environment that includes the columns of the original data passed to \code{tt()}, and \code{groupi} indices. See examples below.
}}

\item{digits}{Number of significant digits or decimal places.}

\item{num_fmt}{The format for numeric values; one of 'significant', 'significant_cell', 'decimal', or 'scientific'.}

\item{num_zero}{Logical; if TRUE, trailing zeros are kept in "decimal" format (but not in "significant" format).}

\item{num_suffix}{Logical; if TRUE display short numbers with \code{digits} significant digits and K (thousands), M (millions), B (billions), or T (trillions) suffixes.}

\item{num_mark_big}{Character to use as a thousands separator.}

\item{num_mark_dec}{Decimal mark character. Default is the global option 'OutDec'.}

\item{date}{A string passed to the \code{format()} function, such as "\%Y-\%m-\%d". See the "Details" section in \code{?strptime}}

\item{bool}{A function to format logical columns. Defaults to title case.}

\item{math}{Logical. If TRUE, wrap cell values in math mode \verb{$..$}. This is useful for LaTeX output or with HTML MathJax \code{options(tinytable_html_mathjax=TRUE)}.}

\item{other}{A function to format columns of other types. Defaults to \code{as.character()}.}

\item{replace}{Logical, String or Named list of vectors
\itemize{
\item TRUE: Replace \code{NA} and \code{NaN} by an empty string.
\item FALSE: Print \code{NA} and \code{NaN} as strings.
\item String: Replace \code{NA} and \code{NaN} entries by the user-supplied string.
\item Named list: Replace matching elements of the vectors in the list by theirs names. Example:
\itemize{
\item \code{list("-" = c(NA, NaN), "Tiny" = -Inf, "Massive" = Inf)}
}
}}

\item{escape}{Logical or "latex" or "html". If TRUE, escape special characters to display them as text in the format of the output of a \code{tt()} table.
\itemize{
\item If \code{i} and \code{j} are both \code{NULL}, escape all cells, column names, caption, notes, and spanning labels created by \code{group_tt()}.
}}

\item{markdown}{Logical; if TRUE, render markdown syntax in cells. Ex: \verb{_italicized text_} is properly italicized in HTML and LaTeX.}

\item{quarto}{Logical. Enable Quarto data processing and wrap cell content in a \code{data-qmd} span (HTML) or \verb{\\QuartoMarkdownBase64\{\}} macro (LaTeX). See warnings in the Global Options section below.}

\item{fn}{Function for custom formatting. Accepts a vector and returns a character vector of the same length.}

\item{sprintf}{String passed to the \code{?sprintf} function to format numbers or interpolate strings with a user-defined pattern (similar to the \code{glue} package, but using Base R).}

\item{linebreak}{NULL or a single string. If it is a string, replaces that string with appropriate line break sequences depending on the output format (HTML: \verb{<br>}, LaTeX: \verb{\\\\\\\\}, Typst: \verb{\\\\ }). Markdown output is excluded from line break replacement.}

\item{output}{Apply formatting only if the \code{tt()} object is rendered in the specified format. One of "latex", "html", "typst", or "markdown". If \code{NULL} (default), apply formatting regardless of the output format.}
}
\value{
A data frame with formatted columns.
}
\description{
This function formats the columns of a data frame based on the column type (logical, date, numeric).
It allows various formatting options like significant digits, decimal points, and scientific notation.
It also includes custom formatting for date and boolean values.
If this function is applied several times to the same cell, the last transformation is retained and the previous calls are ignored, except for the \code{escape} argument which can be applied to previously transformed data.
}
\section{Global options}{


Options can be set with \code{options()} and change the default behavior of tinytable. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(tinytable_tt_digits = 4)
tt(head(iris))
}\if{html}{\out{</div>}}

You can set options in a script or via \code{.Rprofile}. Note: be cautious with \code{.Rprofile} settings as they may affect reproducibility.
\subsection{Default values for function arguments}{

Nearly all of the package's functions retrieve their default values from global options. This allows you to set defaults once and apply them to all tables without needing to specify them each time. For example, to fix the the \code{digits} argument of the \code{tt()} function globally, call:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(tinytable_tt_digits = 4)
}\if{html}{\out{</div>}}

In addition, some more specific options are available to control the behavior of the package in specific contexts.
\itemize{
\item \code{tinytable_html_mathjax}: Insert MathJax scripts (warning: may conflict if MathJax is loaded elsewhere)
\item \code{tinytable_pdf_clean}: Delete temporary and log files for pdf output in \code{save_tt()}
\item \code{tinytable_color_name_normalization}: Enable/disable automatic color name processing (default: TRUE). When enabled, R color names recognized by \code{col2rgb()} are converted to hex format for consistent rendering across HTML, LaTeX, and Typst formats. If R color conversion fails, LaTeX color names are used as fallback. Colors explicitly supplied as hex values with "#" prefix are passed through unchanged. Set to FALSE to disable processing and pass color names unchanged.
}
\subsection{Quarto}{

The \code{format_tt(quarto=TRUE)} argument enables Quarto data processing with some limitations:
\enumerate{
\item The \verb{\\QuartoMarkdownBase64\{\}} LaTeX macro may not process references and markdown as expected
\item Quarto processing may conflict with \code{tinytable} styling/formatting
}

Options:
\itemize{
\item \code{tinytable_quarto_disable_processing}: Disable Quarto cell processing
}

Example of Quarto-specific code in cells:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- data.frame(Math = "x^2^", Citation = "@Lovelace1842")
fn <- function(z) sprintf("<span data-qmd='\%s'></span>", z)
tt(x) |> format_tt(i = 1, fn = fn)
}\if{html}{\out{</div>}}

For more details on Quarto table processing: https://quarto.org/docs/authoring/tables.html#disabling-quarto-table-processing
}

}
}

\examples{
dat <- data.frame(
  a = rnorm(3, mean = 10000),
  b = rnorm(3, 10000)
)
tab <- tt(dat)
format_tt(tab,
  digits = 2,
  num_mark_dec = ",",
  num_mark_big = " "
)

k <- tt(data.frame(x = c(0.000123456789, 12.4356789)))
format_tt(k, digits = 2, num_fmt = "significant_cell")

dat <- data.frame(
  a = c("Burger", "Halloumi", "Tofu", "Beans"),
  b = c(1.43202, 201.399, 0.146188, 0.0031),
  c = c(98938272783457, 7288839482, 29111727, 93945)
)
tt(dat) |>
  format_tt(j = "a", sprintf = "Food: \%s") |>
  format_tt(j = 2, digits = 1, num_fmt = "decimal", num_zero = TRUE) |>
  format_tt(j = "c", digits = 2, num_suffix = TRUE)

y <- tt(data.frame(x = c(123456789.678, 12435.6789)))
format_tt(y, digits = 3, num_mark_big = " ")

x <- tt(data.frame(Text = c("_italicized text_", "__bold text__")))
format_tt(x, markdown = TRUE)

# Line breaks using linebreak argument
d <- data.frame(Text = "First line<br>Second line")
tt(d) |> format_tt(linebreak = "<br>")

# Non-standard evaluation (NSE)
dat <- data.frame(
  w = c(143002.2092, 201399.181, 100188.3883),
  x = c(1.43402, 201.399, 0.134588),
  y = as.Date(c(897, 232, 198), origin = "1970-01-01"),
  z = c(TRUE, TRUE, FALSE)
)
tt(dat) |>
  format_tt(i = w > 150000, j = w, digits = 0, num_mark_big = ",")

tab <- data.frame(a = c(NA, 1, 2), b = c(3, NA, 5))
tt(tab) |> format_tt(replace = "-")

dat <- data.frame(
  "LaTeX" = c("Dollars $", "Percent \%", "Underscore _"),
  "HTML" = c("<br>", "<sup>4</sup>", "<emph>blah</emph>")
)
tt(dat) |> format_tt(escape = TRUE)

}
