% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{World}
\alias{World}
\title{World dataset}
\source{
NED: Natural Earth Data \url{https://www.naturalearthdata.com/}

HPI: Happy Planet Index \url{https://happyplanetindex.org/}

UNDP: Human Development Report (2024) \url{https://hdr.undp.org/content/human-development-report-2023-24}

WB: World Bank \url{https://data.worldbank.org}

OWiD: Our World in Data \url{https://ourworldindata.org}

RSF: Reporters Without Borders \url{https://rsf.org/en/index}
}
\usage{
World
}
\description{
World dataset, class \code{\link[sf:sf]{sf}}
}
\details{
\tabular{lll}{
   \strong{Variable} \tab \strong{Source} \tab \strong{Description} \cr
   \code{iso_a3} \tab NED \tab ISO 3166-1 alpha-3 three-letter country code (see below) \cr
   \code{name} \tab NED \tab Country name \cr
   \code{sovereignt} \tab NED \tab Sovereignt country name \cr
   \code{continent} \tab NED \tab Continent (primary; some countries are transcontinental) \cr
   \code{area} \tab NED \tab Area in km2 \cr
   \code{pop_est} \tab NED \tab Population estimation \cr
   \code{pop_est_dens} \tab NED \tab Population estimation per km2 \cr
   \code{economy} \tab NED \tab Economy class \cr
   \code{income_grp} \tab NED \tab Income group \cr
   \code{gdp_cap_est} \tab NED \tab GDP per capita (estimated) \cr
   \code{life_exp} \tab HPI \tab Life expectancy. The average number of years an infant born in that country is expected to live \cr
   \code{well_being} \tab HPI \tab Well being. Self-reported from 0 (worst) to 10 (best) \cr
   \code{footprint} \tab HPI \tab Carbon footprint. Per capita greendwelling gas emissions associated with consumption and economic activity \cr
   \code{HPI} \tab HPI \tab Happy Planet Indicator. An index of human well-being and environmental impact that was introduced by the New Economics Foundation in 2006. Approximate formula: \code{(life_exp * well_being) / footprint} \cr
   \code{inequality} \tab WB \tab Income inequality: Gini coefficient (World Bank variable SI.POV.GINI) A value of 0 represents perfect equality, while 100 implies perfect inequality \cr
   \code{gender} \tab UNDP/OWiD \tab Gender Inequality Index (GII) Composite metric using reproductive health, empowerment and the labour market. A low value indicates low inequality between women and men, and vice-versa \cr
   \code{press} \tab RSF \tab World Press Freedom Index. Degree of freedom that journalists, news organizations and netizens have \cr
}


See sources for more detailed information about the variables.

This dataset, created Noveber 2024, is an update from the old version, which has been created around 2016. All variables from the old version are included, but updated. Furthermore, gender ineuqlity and press freedom have been added.

ISO country-code: two countries have user-assigned codes, namely: XKX is used for Kosovo (conform European Union and World Bank) (was UNK in the old version); XNC is used for Northern Cyprus (was CYN in the old version).

For some variables data were available from multiple years, but availability was different across countries. In those cases, the most recent values were taken.
}
\keyword{datasets}
