% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topoWeightedDist.R
\name{topoWeightedDist}
\alias{topoWeightedDist}
\title{Weighted topographic distances and paths}
\usage{
topoWeightedDist(
  DEM,
  pts,
  directions = 8,
  paths = FALSE,
  hFunction = NULL,
  vFunction = NULL
)
}
\arguments{
\item{DEM}{A RasterLayer for digital elevation model (DEM) data; should be in a projected coordinate system.}

\item{pts}{A SpatialPoints object or two-column matrix with xy coordinates for the geographic points from which to calculate pairwise distances and paths.}

\item{directions}{numeric (default = 8). The number of directions for movement between cells, either 4 or 8.}

\item{paths}{logical. Default is FALSE, in which case only topographic distances are calculated.  If TRUE, topographic paths are also identified.}

\item{hFunction}{character or function (default = NULL). A function describing the cost of changing aspect angle.}

\item{vFunction}{character or function (default = NULL). A function describing the cost of movement along an incline.}
}
\value{
Matrix of transport costs (if paths = FALSE), or a list containing a matrix of transport costs and paths as an object of class SpatialLines (if paths = TRUE).
}
\description{
Calculates weighted topographic distances and paths
}
\details{
The hFunction argument can be set to "exponential" or "linear" to use standard functions for the cost of aspect angle changes. If providing a custom function instead, the equation should be a function of one variable, angle (in radians).
The vFunction argument can be set to "exponential" or "quadratic" to use standard functions for the cost of movement along an incline.  If providing a custom function instead, The equation should be a function of one variable, slope.
If paths = FALSE, the function will return a matrix of pairwise topographic distances between the specified points.
If paths = TRUE, the function will return a list with two items: (1) the matrix of pairwise topographic distances,
and (2) a SpatialLines object containing the topographic paths.
}
\examples{
xy <- matrix(ncol = 2, byrow = TRUE,
             c(-119.5566, 37.7247,
               -119.4718, 37.7608))
topoWeightedDist(Yosemite$DEM, xy, vFunction = "exponential")
}
