% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters_and_getters.R
\name{get_sign_and_sugg_loci}
\alias{get_sign_and_sugg_loci}
\title{Get the index/lead variants}
\usage{
get_sign_and_sugg_loci(
  df,
  genome_wide_thresh = 5e-08,
  suggestive_thresh = 1e-06,
  flank_size = 1e+06,
  region_size = 1e+06
)
}
\arguments{
\item{df}{Dataframe, GWAS summary statistics}

\item{genome_wide_thresh}{A number. P-value threshold for genome wide significant loci (5e-08 by default)}

\item{suggestive_thresh}{A number. P-value threshold for suggestive loci (1e-06 by default)}

\item{flank_size}{A number (default = 1e6). The size of the flanking region for the significant and suggestitve snps.}

\item{region_size}{A number (default = 1e6). The size of the region for top snp search. Only one snp per region is returned.}
}
\value{
List of genome wide and suggestive loci.
}
\description{
\code{get_lead_snps()} Get the top variants within 1 MB windows of the genome with association p-values below the given threshold
}
\examples{
\dontrun{
get_sign_and_sugg_loci(CD_UKBB)
}

}
