% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tttr}
\alias{tttr}
\title{Calculate TTTR Metric Score}
\usage{
tttr(travel_time_readings = NULL, monthly = FALSE, verbose = FALSE)
}
\arguments{
\item{travel_time_readings}{path to RITIS export CSV with 15-minute average readings for trucks}

\item{monthly}{TRUE or FALSE specifies if the results should be
aggregated by month. If FALSE scores will be computed by TMC for all
data in the input file.}

\item{verbose}{Provide diagnostic output and return all calculated values (necessary for \code{\link{hpms}} function)}
}
\value{
A data.table of TTTR scores by TMC
}
\description{
Calculate TTTR given a RITIS NPMRDS export of travel time data.
Data is passed in as the path to the csv containing the travel time readings.\
Travel time units must be seconds and averaging should be 15 minutes.
}
\examples{
\dontrun{
tttr("data/Trucks/Readings.csv")
tttr("data/Trucks/Readings.csv", monthly = TRUE)
}

}
