% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.dataset_function.R
\name{get.dataset}
\alias{get.dataset}
\title{Get the selected dataset}
\usage{
get.dataset(pmid, show.index = FALSE, show.type = FALSE)
}
\arguments{
\item{pmid}{A scalar with the PMID number of the systematic review found in
the database.}

\item{show.index}{Logical to indicate whether to return a data-frame with the
full name of the abbreviated characteristics. The default is
\code{FALSE} (do not report).}

\item{show.type}{Logical to indicate whether to return a data-frame with the
type (Demographic, Clinical, Methodological) and subtype (Age, Ethnicity,
Intervention, Outcome, Participant, Risk of bias, Sex, Study design, Study
setting, Withdrawals) of the characteristics. The default is \code{FALSE}
(do not report).}
}
\value{
\code{get.dataset} returns the following:
\item{Dataset}{A data-frame (tibble style) with rows referring to the
  studies and columns to the study-level aggregate characteristics as
  extracted from the report of the corresponding systematic review.}
\item{Characteristics_index}{A data-frame (tibble style) with the rows
  referring to the extracted characteristics (abbreviated name) and columns
  to the their full name (if \code{show.index = TRUE}), their type and
  subtype (if \code{show.type = TRUE}).}
}
\description{
Retrieving a dataset with study-level aggregate clinical and
methodological characteristics (that may act as effect modifiers) extracted
from the selected systematic review of the database.
}
\details{
The selected dataset refers to a connected network for a specific outcome
studied in the corresponding systematic review. Each characteristic occupies
one column in the dataset.
Characteristics pertaining to intervention features occupied one column for
the experimental and another for the control treatment in the corresponding
comparison.
}
\examples{
get.dataset(pmid = 25626481)

}
\author{
{Loukia M. Spineli}
}
