% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.randomForest.prmdt}
\alias{predict.randomForest.prmdt}
\title{predict.randomForest.prmdt}
\usage{
\method{predict}{randomForest.prmdt}(
  object,
  newdata,
  type = "class",
  norm.votes = TRUE,
  predict.all = FALSE,
  proximity = FALSE,
  nodes = FALSE,
  cutoff,
  ...
)
}
\arguments{
\item{object}{a \code{\link[randomForest]{randomForest}} model object for which prediction is desired.}

\item{newdata}{an optional data frame in which to look for variables with which to predict.}

\item{type}{type of prediction 'prob' or 'class' (default).}

\item{norm.votes}{Should the vote counts be normalized (i.e., expressed as fractions)? Ignored if object$type is regression.}

\item{predict.all}{Should the predictions of all trees be kept?}

\item{proximity}{Should proximity measures be computed? An error is issued if object$type is regression.}

\item{nodes}{Should the terminal node indicators (an n by ntree matrix) be return? If so, it is in the ``nodes'' attribute of the returned object.}

\item{cutoff}{(Classification only) A vector of length equal to number of classes. The `winning' class for an observation is the one with the maximum ratio of proportion of votes to cutoff. Default is taken from the forest$cutoff component of object (i.e., the setting used when running randomForest).}

\item{...}{additional arguments affecting the predictions produced.}
}
\value{
a vector or matrix of predictions for randomforest model.
}
\description{
Return prediction for a \code{\link[randomForest]{randomForest}} model.
}
