% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nankivell_walser.R
\name{nankivell}
\alias{nankivell}
\title{eGFR using Nankivell formula}
\usage{
nankivell(SCr, Urea, Weight, Height, Sex, Units = "SI")
}
\arguments{
\item{SCr}{numeric vector of serum creatinine in µmol/l (or mg/dl if units = "US")}

\item{Urea}{numeric vector of serum urea in mmol/l (or BUN in mg/dl if units = "US")}

\item{Weight}{numeric vector of patient weights in kilograms}

\item{Height}{numeric vector of patient heights in centimetres}

\item{Sex}{character vector of sex ("F" for female, "M" for male)}

\item{Units}{non-vectorised optional parameter for creatinine and urea/BUN units ("SI" for µmol/l (default), "US" for mg/dl)}
}
\value{
a numeric vector of eGFR values
}
\description{
A vectorised function to calculate eGFR using the Nankivell formula. By default the equation accepts
serum creatinine in µmol/l but can be changed to mg/dl by setting the units parameter to "US".
The Urea parameter is serum urea in mmol/l, but if the units parameter is set to "US",
Blood Urea Nitrogen (BUN) in mg/dl is used instead. It has not been possible to run automated
tests to confirm the
accuracy of this function, so please use with caution.
}
\details{
Reference: Nankivell BJ, Gruenwald SM, Allen RD, Chapman JR: Predicting glomerular filtration rate
after renal transplantation. Transplantation 1995; 59:1683-89.
}
\examples{
nankivell(SCr = 118, Urea = 13.4, Weight = 65, Height = 172, Sex = "M") # 44.55
}
