% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukkri.R
\name{ukkrri}
\alias{ukkrri}
\title{UK Kidney Recipient Risk Index (NHSBT, 2019 version)}
\usage{
ukkrri(age, dx, wait, dm)
}
\arguments{
\item{age}{numeric vector of patient ages in years}

\item{dx}{numeric vector of whether on dialysis at time of listing (1 = yes, 0 = no)}

\item{wait}{numeric vector of waiting time from start of dialysis}

\item{dm}{numeric vector of whether patient has diabetes (1 = yes, 0 = no)}
}
\value{
numeric vector of UK Kidney Recipient Risk Index values
}
\description{
A vectorised function to calculate the UK Kidney Recipient Risk Index as used in the new
national kidney matching scheme implemented in September 2019.
}
\details{
The UK KRRI is documented in the UK kidney matching policy which can be found on the
NHS Blood & Transplant ODT website at www.odt.nhs.uk
}
\examples{
ukkrri(age = 45, dx = 0, wait = 750, dm = 0)
}
