% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-basic.R
\name{diffx-rdiffx-ldiffx}
\alias{diffx-rdiffx-ldiffx}
\alias{diffx}
\alias{rdiffx}
\alias{ldiffx}
\title{Compute lagged differnces}
\usage{
diffx(x, n = 1L, order = 1L, rho = 1, fill = NA)

rdiffx(x, n = 1L, order = 1L, rho = NULL, fill = NA)

ldiffx(x, n = 1L, order = 1L, rho = 1, fill = NA)
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{n}{\verb{[positive integer(1): 1L]}

Value indicating which lag to use.}

\item{order}{\verb{[positive integer(1): 1L]}

Value indicating the order of the difference.}

\item{rho}{\verb{[numeric(1): NULL]}

Value indicating the autocorrelation parameter. The purpose of this parameter is
to provide  quasi-differencing assuming the value falls within 0 and 1.}

\item{fill}{\verb{[numeric or function: NA]}

Numeric value(s) or function used to fill observations.}
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}

Returns suitably lagged and iterated difference
\itemize{
\item \code{diffx} computes simple differences.
\item \code{rdffix} computes percentage differences.
\item \code{ldiffx} computes logged differences.
}
}
\examples{
x <- c(2, 4, 8, 20)
diffx(x)
rdiffx(x)
ldiffx(x)

}
