% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-trends.R
\name{dtrend}
\alias{dtrend}
\alias{dtrend_lin}
\alias{dtrend_quad}
\alias{dtrend_poly}
\title{Deterministic Trend}
\usage{
dtrend_lin(x, bp = NULL, na.rm = getOption("transx.na.rm"))

dtrend_quad(x, bp = NULL, na.rm = getOption("transx.na.rm"))

dtrend_poly(x, degree, bp = NULL, na.rm = getOption("transx.na.rm"))
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{bp}{\verb{[positive integer(1)]}

Break points to define piecewise segments of the data.}

\item{na.rm}{\verb{[logical(1): getOption("transx.na.rm")]}

A value indicating whether NA values should be stripped before the computation proceeds.}

\item{degree}{\verb{[positive integer(1)]}

Value indicating the degree of polynomial}
}
\value{
Returns a vector with the same class and attributes as the input vector.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}

Remove global deterministic trend information from the series.
\itemize{
\item \code{dt_lin} removes the linear trend.
\item \code{dt_quad} removes the quadratic trend.
\item \code{dt_poly} removes the nth-degree polynomial trend.
}
}
\examples{

set.seed(123)
t <- 1:20

# Linear trend
x <-  3*sin(t) + t
plotx(cbind(x, dtrend_lin(x)))

# Quadratic trend
x2 <-  3*sin(t) + t + t^2
plotx(cbind(raw = x2, quad = dtrend_quad(x2)))

# Introduce a breaking point at point = 10
xbp <- 3*sin(t) + t
xbp[10:20] <- x[10:20] + 15
plotx(cbind(raw = xbp, lin = dtrend_lin(xbp), lin_bp = dtrend_lin(xbp, bp = 10)))

}
