% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill.R
\name{fill_nocb}
\alias{fill_nocb}
\title{Fill with "Next observation carried backwards"}
\usage{
fill_nocb(body, idx, fail = NA)
}
\arguments{
\item{body}{\verb{[numeric vector]}

The body of the vector.}

\item{idx}{\verb{[integer vector]}

the index to replace with.}

\item{fail}{\verb{[numeric(1) or numeric vector: fill]}

In case it fails to fill some values.}
}
\value{
Returns a vector with the same class and attributes as the input vector.
}
\description{
Fill with "Next observation carried backwards"
}
\examples{
x <- c(5,3,2,2,5)
leadx(x, n = 2, fill = fill_locf)

xlen <- length(x)
n <- 2
n <- pmin(n, xlen)
idx <- (xlen - n + 1):xlen
body <- x[-seq_len(n)]
fill_locf(body, idx, NA)



}
