% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-filter.R
\name{filter_hamilton}
\alias{filter_hamilton}
\title{Hamilton Filter}
\usage{
filter_hamilton(x, p = 4, horizon = 8, fill = NA)
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{p}{\verb{[integer(1): 4]}

A value indicating the number of lags}

\item{horizon}{\verb{[integer(1): 8]}

A value indicating the number of periods to look ahead.}

\item{fill}{\verb{[numeric or function: NA]}

Numeric value(s) or function used to fill observations.}
}
\value{
Returns a vector with the same class and attributes as the input vector.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}

This function computes the cyclical component of the Hamilton filter.
}
\examples{
unemp <- ggplot2::economics$unemploy
unemp_cycle <- filter_hamilton(unemp)
plotx(cbind(unemp, unemp_cycle))
}
