% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-root-power.R
\name{pow_yj}
\alias{pow_yj}
\title{Yeo and Johnson(2000) Transformations}
\usage{
pow_yj(x, lambda = NULL, ...)
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{lambda}{\verb{[numeric(1): NULL]}

Transformation exponent, \eqn{\lambda}.}

\item{...}{Further arguments passed to \code{pow}.}
}
\value{
Returns a vector with the same class and attributes as the input vector.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}
}
\examples{
set.seed(123)
x <- runif(10)
pow_yj(x, 3)
}
\references{
Yeo, I., & Johnson, R. (2000).
A New Family of Power Transformations to Improve Normality or Symmetry. Biometrika, 87(4), 954-959.
\url{http://www.jstor.org/stable/2673623}
}
