% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3DImbalIndices.R
\name{all3DImbalIndices}
\alias{all3DImbalIndices}
\alias{A_Index}
\alias{alpha_Index}
\alias{M_Index}
\alias{mu_Index}
\alias{imbalInt_e}
\alias{imbalProfile_e}
\title{Calculation of integral-based distance- and angle-based 3D imbalance indices}
\usage{
all3DImbalIndices(
  tree,
  imbal_type,
  weight = "edge_weight",
  rel.tolerance = 1e-10,
  max.subdiv = 200L
)

A_Index(tree, weight = "edge_weight", rel.tolerance = 1e-10, max.subdiv = 200L)

alpha_Index(
  tree,
  weight = "edge_weight",
  rel.tolerance = 1e-10,
  max.subdiv = 200L
)

M_Index(tree, weight = "edge_weight", rel.tolerance = 1e-10, max.subdiv = 200L)

mu_Index(
  tree,
  weight = "edge_weight",
  rel.tolerance = 1e-10,
  max.subdiv = 200L
)

imbalInt_e(
  p,
  v,
  centr_v,
  centr_v_weight,
  edge_weight,
  imbal_type,
  rel.tolerance = 1e-08,
  max.subdiv = 200L
)

imbalProfile_e(xs, p, v, centr_v, centr_v_weight, edge_weight, imbal_type)
}
\arguments{
\item{tree}{A rooted tree in phylo3D format (no special node enumeration 
required, except that nodes are numbered from 1 to |V| = the total number of
nodes). There must be at least 2 nodes, i.e., one edge. The attributes 
'node.coord' and 'edge.weight' are strictly required.}

\item{imbal_type}{Specifies which node imbalance measurement should be used.
Available are:\cr
"A"     - centroid angle\cr
"alpha" - minimal centroid angle\cr
"M"     - expanded relative centroid distance\cr
"mu"    - relative centroid distance}

\item{weight}{Specifies how the node imbalance values should be weighted.
Available weighting methods are: \cr
"edge_weight" (default) -> Imbalance with regards to the total edge 
weight.\cr
"edge_length" -> Imbalance with regards to the total edge length.}

\item{rel.tolerance}{(Optional) Numeric value which specifies the relative 
tolerance which should be used for estimating the integral using 
stats::integrate. Set to 1e-10 by default (the stats::integrate default 
value is approx 3e-16).}

\item{max.subdiv}{(Optional) Integer value which specifies the maximal number 
of interval subdivisions for estimating the integral using stats::integrate. 
Set to 200 by default (stats::integrate default value 100).}

\item{p}{Numeric vector of size 3 (3D coordinates of parent node \eqn{p}).}

\item{v}{Numeric vector of size 3 (3D coordinates of node \eqn{v}).}

\item{centr_v}{Numeric vector of size 3 (3D coordinates of the centroid of
the pending subtree of node \eqn{v}).}

\item{centr_v_weight}{Numeric value >=0 (weight of the pending subtree of 
node \eqn{v}).}

\item{edge_weight}{Numeric value >=0 (weight of the edge \eqn{(p,v)}).}

\item{xs}{Numeric vector with values between 0 (included) and 1 (excluded).
Set of edge subdivisions.}
}
\value{
\code{all3DImbalIndices} Numeric value indicating the internal 3D
imbalance according to the chosen method.

\code{A_Index} Numeric value in the interval 
between 0 (included) and \eqn{\pi} (excluded). A value near \eqn{\pi} 
indicates a higher degree and near 0 a lower degree of asymmetry.

\code{alpha_Index} Numeric value in the interval 
between 0 (included) and \eqn{\pi/2} (excluded). A value near \eqn{\pi/2} 
indicates a higher degree and near 0 a lower degree of asymmetry.

\code{M_Index} Numeric value in the interval 
between 0 (included) and 1 (excluded). A value near 1 indicates a higher 
degree and near 0 a lower degree of asymmetry.

\code{mu_Index} Numeric value in the interval between 0 (included) 
and 1 (excluded). A value near 1 indicates a higher degree and near 0 a 
lower degree of asymmetry.

\code{imbalInt_e} Numeric value (0 minimal value, higher values
indicate a higher degree of asymmetry).

\code{imbalProfile_e} Numeric vector of imbalance values (0 minimal 
value, higher values indicate a higher degree of asymmetry) for the edge
subdivisions indicated by input \code{xs}.
}
\description{
\code{all3DImbalIndices} - This serves as a wrapper function to calculate 
a 3D imbalance index value of a 3D tree in phylo3D format according to the 
specified imbalance measurement and weighting scheme.\cr
If problems occur with the estimation of the integrals, try to increase 
the optional parameters  \cr\code{rel.tolerance} and \code{max.subdiv}.

\code{A_Index} - Calculates the 3D imbalance index "weighted integral-based 
centroid angle" of a 3D tree in phylo3D format using either the 
edge weights or the edge lengths as weights.\cr
If problems occur with the estimation of the integrals, try to increase 
the optional parameters  \cr\code{rel.tolerance} and \code{max.subdiv}.

\code{alpha_Index} - Calculates the 3D imbalance index "weighted 
integral-based minimal centroid angle" of a 3D tree in phylo3D format using 
either the edge weights or the edge lengths as weights.\cr
If problems occur with the estimation of the integrals, try to increase 
the optional parameters  \cr\code{rel.tolerance} and \code{max.subdiv}.

\code{M_Index} - Calculates the 3D imbalance index "weighted integral-based 
expanded relative centroid distance" of a 3D tree in phylo3D format using 
either the edge weights or the edge lengths as weights.\cr
If problems occur with the estimation of the integrals, try to increase 
the optional parameters  \cr\code{rel.tolerance} and \code{max.subdiv}.

\code{mu_Int} - Calculates the 3D imbalance index "weighted integral-based 
relative centroid distance" of a 3D tree in phylo3D format using either the 
edge weights or the edge lengths as weights.\cr
If problems occur with the estimation of the integrals, try to increase 
the optional parameters  \cr\code{rel.tolerance} and \code{max.subdiv}.

\code{imbalInt_e} - Calculates the integral of the node imbalance values
over all possible subdividing nodes on an edge.

\code{imbalProfile_e} - Calculates the node imbalance values
for a given set of subdivisions of an edge.
}
\examples{
tree <- treeDbalance::extendPhylo(treeDbalance::example3Dtrees$bean09)
all3DImbalIndices(tree, imbal_type = "A", weight="edge_length")
A_Index(tree, weight="edge_weight")
alpha_Index(tree)
M_Index(tree, weight="edge_length")
mu_Index(tree, weight="edge_length")
imbalInt_e(p=c(0,0,1),v=c(0,0,0),centr_v=c(0.5,0,0),
    centr_v_weight=1,edge_weight=1,imbal_type="mu")
imbalProfile_e(xs=c(0,0.2,0.4),p=c(1,1,0),v=c(0,0,0),centr_v=c(0.5,0,0),
    centr_v_weight=1,edge_weight=1,imbal_type="A")
}
\author{
Sophie Kersting
}
